package commands

import (
	"github.com/spf13/cobra"

	"a.yandex-team.ru/security/meat/internal/server"
)

var serverCmd = &cobra.Command{
	Use:  "server",
	RunE: runServer,
}

func init() {
	RootCmd.AddCommand(serverCmd)
}

func runServer(_ *cobra.Command, _ []string) error {
	srv, err := server.NewServer(cfg)
	if err != nil {
		return err
	}

	return srv.ListenAndServe()
}
