package config

import (
	"a.yandex-team.ru/library/go/yandex/tvm"
)

type TVM struct {
	ClientID     tvm.ClientID            `json:"tvm_id"`
	ClientSecret string                  `json:"-"`
	CacheDir     string                  `json:"cache_dir"`
	Destinations map[string]tvm.ClientID `json:"dests"`
	Env          tvm.BlackboxEnv         `json:"env"`
}

type Role struct {
	Name string `json:"name"`
	Slug string `json:"slug"`
}

type Config struct {
	Debug      bool   `json:"debug"`
	Port       int    `json:"port"`
	SignSecret string `json:"-"`
	BuildCmd   string `json:"build-cmd"`
	StaticRoot string `json:"static-root"`
	TVM        TVM    `json:"tvm"`
	Role       Role   `json:"role"`
}
