package server

import (
	"github.com/gorilla/websocket"
	"github.com/labstack/echo/v4"

	"a.yandex-team.ru/security/libs/go/simplelog"
)

var (
	wsUpgrader = websocket.Upgrader{}
)

func (s *Server) clickerWsHandler(e echo.Context) error {

	ws, err := wsUpgrader.Upgrade(e.Response(), e.Request(), nil)
	if err != nil {
		simplelog.Error("failed to upgrade clicker ws", "err", err)
		return err
	}

	defer func() { _ = ws.Close() }()

	client := s.clickersHub.NewClient(ws)

	go client.WriteLoop()
	client.ReadLoop()
	return nil
}
