package main

import (
	"context"
	"os"

	"a.yandex-team.ru/kikimr/public/sdk/go/persqueue"
	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/yandex/tvm/tvmtool"
	"a.yandex-team.ru/security/libs/go/ydbtvm"
)

type LbWriter struct {
	writer persqueue.Writer
	logger log.Logger
}

func NewLbWriter(logger log.Logger, ctx context.Context) LbWriter {
	tvmClient, err := tvmtool.NewDeployClient()
	if err != nil {
		logger.Fatal("tvmClient error", log.Error(err))
	}

	lbCredentials := &ydbtvm.TvmCredentials{
		DstID:     ydbtvm.LbClientID,
		TvmClient: tvmClient,
	}
	wrOpts := persqueue.WriterOptions{
		Endpoint:    "logbroker.yandex.net",
		Credentials: lbCredentials,
		Logger:      logger,
		Topic:       "/molly/molly-http-log",
		SourceID:    []byte(os.Getenv("DEPLOY_POD_ID")),
		Codec:       persqueue.Raw,
	}

	writer := persqueue.NewWriter(wrOpts)

	_, err = writer.Init(ctx)
	if err != nil {
		logger.Fatal("Unable to start writer", log.Error(err))
	}

	go func(w persqueue.Writer) {
		for rsp := range w.C() {
			switch m := rsp.(type) {
			case *persqueue.Issue:
				logger.Error("Error", log.Error(m.Err))
			}
		}
	}(writer)

	return LbWriter{
		writer: writer,
		logger: logger,
	}
}

func (lb *LbWriter) Write(msg []byte) {
	data := &persqueue.WriteMessage{
		Data: msg,
	}
	err := lb.writer.Write(data)
	if err != nil {
		lb.logger.Fatal("Can't write", log.Error(err))
	}
}
