# -*- coding: utf-8 -*-
from django.conf.urls import url

from .views import ScanHandler, StatHandler, TargetList, TargetHandler, \
    ScanList, VulnTypeInfoHandler, TicketsList, CrasherHandler, SampleUploadHandler, \
    CrasherChunkHandler, ScanQueueHandler, EnvList, StWebhookHandler

urlpatterns = [
    url(r'^v1.1/scan/$', ScanHandler.as_view()),
    url(r'^v1.1/scan/queue/?$', ScanQueueHandler.as_view()),
    url(r'^v1.1/scan/list/$', ScanList.as_view()),
    url(r'^v1.1/scan/(?P<scan_id>[\w-]+)/?$', ScanHandler.as_view()),
    url(r'^v1.1/vuln-type/$', VulnTypeInfoHandler.as_view()),
    url(r'^v1/stat/$', StatHandler.as_view()),
    url(r'^v1.1/targets/$', TargetList.as_view()),
    url(r'^v1.1/target/(?P<id>\d+)/?$', TargetHandler.as_view()),
    url(r'^v1.1/tickets/$', TicketsList.as_view()),
    url(r'^v1.1/crasher/$', CrasherHandler.as_view()),
    url(r'^v1.1/req-samples/$', SampleUploadHandler.as_view()),
    url(r'^v1.1/crasher-state/$', CrasherChunkHandler.as_view()),
    url(r'^v1.1/crasher-state/(?P<uid>[\w-]+)/?$', CrasherChunkHandler.as_view()),
    url(r'^v1.1/environments/$', EnvList.as_view()),
    url(r'^v1.1/st-webhook-handler/?$', StWebhookHandler.as_view(), name='st_webhook_handler'),
]
