
import sys
import os
from django.conf import settings
from celery import Celery

_PATH = os.path.abspath(os.path.dirname(__file__))
sys.path.append(_PATH)
sys.path.append(_PATH + '/molly_webui')


os.environ.setdefault("DJANGO_SETTINGS_MODULE", "molly_webui.settings")

app = Celery('molly')
app.config_from_object('django.conf:settings', namespace='CELERY')
app.conf.result_serializer = 'pickle'
app.conf.accept_content = {'pickle'}
app.autodiscover_tasks(lambda: settings.INSTALLED_APPS)
