import os
from .settings import _PATH

DEBUG = True

MIDDLEWARE_CLASSES = (
     'django.contrib.sessions.middleware.SessionMiddleware',
     'django.middleware.csrf.CsrfViewMiddleware',
     'django.contrib.auth.middleware.AuthenticationMiddleware',
     'django.contrib.messages.middleware.MessageMiddleware',
     'molly_webui.middleware.AuditMiddleware'
 )

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.admin',
    'rest_framework',
    'molly_webui',
    'molly_webui.api',
    'bootstrap3',
    'sanitizer'
)

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            os.path.join(_PATH, 'templates'),
            '/usr/local/lib/python2.7/dist-packages/django/contrib/admin/templates',
        ],
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.i18n',
                'django.template.context_processors.media',
                'django.contrib.auth.context_processors.auth',
                'django.template.context_processors.static',
                'django.template.context_processors.request',
                'django.contrib.messages.context_processors.messages',
            ],
            # List of callables that know how to import templates from various sources.
            'loaders': [
                'django.template.loaders.filesystem.Loader',
                'django.template.loaders.app_directories.Loader',
            ]
        },
    }
]

YAUTH_BLACKBOX_INSTANCE = None

SITE_NAME = 'localhost'
ALLOWED_HOSTS = ['localhost']

import os

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.postgresql_psycopg2',
        'NAME': 'postgres',
        'USER': 'postgres',
        'PASSWORD': os.environ['PGAAS_PASSWORD'],
        'HOST': '172.17.0.5',
        'CONN_MAX_AGE': 60,
        'PORT': '5432'
    },
}       

HEC_HOST = "hatch.yandex.net"

SOUTH_DATABASE_ADAPTERS = {
    
}

