#-*- coding: utf-8 -*-
import os
from django.utils.translation import ugettext_lazy as _

#---logging---
LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'verbose': {
            'format': '%(levelname)s %(asctime)s %(module)s %(process)d %(thread)d %(message)s'
        },
        'simple': {
            'format': '%(levelname)s %(message)s'
        },
        'splunk': {
            'format': '%(asctime)s molly %(message)s'
        },
    },
    'handlers': {
        'null': {
            'class': 'logging.NullHandler',
        },
        'console': {
            'level': 'DEBUG',
            'class': 'logging.StreamHandler',
            'formatter': 'simple',
        },
        'file': {
            'level': 'DEBUG',
            'class': 'logging.FileHandler',
            'formatter': 'verbose',
            'filename': '/var/log/yandex/django.log', # /dev/stderr qloud
        },
        'mail_admins': {
            'level': 'ERROR',
            'class': 'django.utils.log.AdminEmailHandler'
        },
        'splunk': {
            'level': 'INFO',
            'class': 'logging.handlers.SysLogHandler',
            'formatter': 'splunk',
            'address': ('trapdoor.yandex.net', 514)
        }
    },
    'loggers': {
        'django.request': {
            'handlers': ['mail_admins'],
            'level': 'ERROR',
        },
        'django': {
            'handlers': ['file'],
            'level': 'DEBUG',
            'propagate': True,
        },
    },
    'root': {
        'handlers': ['file'],
        'level': 'INFO',
    },
}
CELERYD_LOG_FILE = "/var/log/yandex/celeryd.log" # /dev/stderr qloud
WIKIFORMATTER_URL = 'https://wf.yandex-team.ru/v4/html'

SITE_NAME = 'molly.yandex-team.ru'

# Russian by default (what for?)
DEFAULT_LANGUAGE = 'ru'

from django_yauth.settings import *

YAUSER_ADMIN_LOGIN = True # дл▒. в▒.ода в админк▒. по ▒.ек▒.▒.ей к▒.ке
CREATE_USER_ON_ACCESS = True
YAUTH_USE_TVM2_FOR_BLACKBOX = True
YAUTH_BLACKBOX_PARAMS['get_user_ticket'] = 'yes'
YAUTH_USE_OAUTH = False
YAUTH_USE_SITES = True
YAUTH_TVM2_CLIENT_ID = 2010214
YAUTH_REAL_IP_HEADERS = ['HTTP_X_FORWARDED_FOR_Y']
METRICS_URL = os.environ.get("METRICS_URL")
ERRORTRACER_URL = os.environ.get("ERRORTRACER_URL")


FALLBACK_REPORT_EMAIL = 'security-testing@yandex-team.ru'
ST_URL = 'https://st-api.yandex-team.ru'
ST_UI_URL = 'https://st.yandex-team.ru'

ALLOWED_HOSTS = ['molly.yandex-team.ru']

ELLIPTICS_PROXY = {'read': 'http://storage-int.mds.yandex.net/get-molly/',
                   'public_read': 'https://molly.yandex-team.ru/elliptics-proxy/',
                   'write': 'http://storage-int.mds.yandex.net:1111/upload-molly/',
                   'delete': 'http://storage-int.mds.yandex.net:1111/delete-molly/'}

GARBAGE_SCAN_MINUTES = 180
TOTAL_GARBAGE_SCAN_DAYS = 1

#CELERY_MAX_TASKS_PER_CHILD = 4

ABC_URL = 'https://abc-back.yandex-team.ru'

HEC_HOST = "hatch.yandex.net"
SANDBOX_RESOURCE_API = 'https://sandbox.yandex-team.ru/api/v1.0/resource'
SKYNET_BIN = '/usr/local/bin/sky'

EMAIL_PER_TARGET_DELAY = 1

COLLABORATOR_SERVER = "burp.sec.yandex.net"
