# -*- coding: utf-8 -*-

from django.conf import settings
from django.core.management.base import BaseCommand

import socket

from molly_webui.notification.send_mail import send_message

class Command(BaseCommand):
    help = ('Check if oauth tokens are alive')

    def get_ip(self):
        s = socket.socket(socket.AF_INET6, socket.SOCK_DGRAM)
        try:
            s.connect(('ns-cache.yandex.net', 53))
            ip = s.getsockname()[0]
        except:
            ip = '127.0.0.1'
        finally:
            s.close()
        return ip

    def notify_oauth_error(self, token_id):
        send_message(to_email=settings.CALLNOTIFICATION_EMAILS,
                     template='notifications/token_expired.html',
                     subject='Молли использует невалидный токен {}!'.format(token_id),
                     data={'token_id': token_id},
                     sender_email=settings.EMAIL_HOST_USER)
        return

    def get_oauth_data(self, token):
        bb = settings.YAUTH_BLACKBOX_INSTANCE
        try:
            session = bb.oauth(token, self.get_ip(), dbfields=list(settings.PASSPORT_FIELDS), by_token=True)
        except Exception:
            raise
        return session

    def handle(self, *args, **options):
        bb_data = dict()
        try:
            bb_data = self.get_oauth_data(settings.ST_OAUTH_TOKEN)
        except Exception:
            pass
        if bb_data.get('status', '') != 'VALID':
            self.notify_oauth_error('ST_OAUTH_TOKEN')
        bb_data = dict()
        try:
            bb_data = self.get_oauth_data(settings.QLOUD_OAUTH_TOKEN.split()[-1])
        except Exception:
            pass
        if bb_data.get('status', '') != 'VALID':
            self.notify_oauth_error('QLOUD_OAUTH_TOKEN')
        bb_data = dict()
        try:
            bb_data = self.get_oauth_data(settings.OAUTH_TOKEN_FOR_STATIC)
        except Exception:
            pass
        if bb_data.get('status', '') != 'VALID':
            self.notify_oauth_error('OAUTH_TOKEN_FOR_STATIC ')
