# -*- coding: utf-8 -*-
import datetime
from dateutil.relativedelta import relativedelta

from django.conf import settings
from django.core.management.base import BaseCommand

from molly_webui.models import Scan
from molly_webui.tasks import stop_remote_scan


class Command(BaseCommand):
    help = ('Revoke hanged scans')
    def handle(self, *args, **options):
        latest_old_scan_time = datetime.datetime.now() + relativedelta(minutes=-settings.GARBAGE_SCAN_MINUTES)
        qs = Scan.objects.filter(status=Scan.ST_INPROGRESS, start__lte=latest_old_scan_time, ignore_time_limit=False)
        for scan in qs:
            scan.status = Scan.ST_ABORTED
            scan.save()
            stop_remote_scan.delay(scan.id)
        latest_old_scan_time = datetime.datetime.now() + relativedelta(days=-settings.TOTAL_GARBAGE_SCAN_DAYS)
        qs = Scan.objects.filter(status=Scan.ST_INPROGRESS, start__lte=latest_old_scan_time)
        for scan in qs:
            scan.status = Scan.ST_ABORTED
            scan.save()
            stop_remote_scan.delay(scan.id)
