# -*- coding: utf-8 -*-

import datetime
from dateutil.relativedelta import relativedelta

from django.conf import settings
from django.core.management.base import BaseCommand

from molly_webui.models import Scan
from molly_webui.notification.solomon import Solomon


class Command(BaseCommand):
    help = ('Collect metrics and send to Solomon')

    def handle(self, *args, **options):
        latest_old_scan_time = datetime.datetime.now() + relativedelta(minutes=-5)
        client = Solomon(project=settings.SOLOMON_PROJECT_ID,
                         cluster=settings.SOLOMON_CLUSTED_ID,
                         service='totals',
                         token=settings.SOLOMON_OAUTH_TOKEN)
        count_inpr = Scan.objects.filter(status=Scan.ST_INPROGRESS).count()
        client.push_sensor('inprogress', count_inpr)
        count_done = Scan.objects.filter(status=Scan.ST_DONE, finish__gte=latest_old_scan_time).count()
        client.push_sensor('done', count_done)
        count_fail = Scan.objects.filter(status=Scan.ST_FAIL, finish__gte=latest_old_scan_time).count()
        client.push_sensor('failed', count_fail)
        count_abrt = Scan.objects.filter(status=Scan.ST_ABORTED, finish__gte=latest_old_scan_time).count()
        client.push_sensor('aborted', count_abrt)
        client.flush()
