# -*- coding: utf-8 -*-
import json
import datetime
from dateutil.relativedelta import relativedelta
from urllib.parse import urlparse

from django.core.management.base import BaseCommand

from molly_webui.models import Scan, ScanTask, Target, ProfilesTasks, ProfilesTargets, ScanProfile,\
    Vulnerability, VulnTicket, AuthProfile, FalsePositive, VulnerabilityType, CrasherStatus, TargetUriMap, \
    RequestSamples, CrasherChunk

from molly_webui.utils import upload_to_elliptics, join_by_domain, slugify_target_url, get_abc_id_by_slug, \
    get_abc_id_by_url, get_latest_aggregate, get_cgroup, get_abc_members, clean_antirobot_header


class Command(BaseCommand):
    help = ('Create puncher requests')
    QLOUD_BASE_URL = 'https://qloud-ext.yandex-team.ru'
    TARGET_BALANCERS = set()
    SRC_NETS = set()

    def get_balancer_net(self, env_id):
        try:
            r = requests.get('{}/api/v1/balancerL7/{}'.format(self.QLOUD_BASE_URL, env_id),
                             headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
            balancer_info = r.json()
        except Exception:
            return ''
        if balancer_info.get('balancerL3Id'):
            self.TARGET_BALANCERS.add(balancer_info.get('balancerL3Id'))
        if not balancer_info.get('environmentId'):
            return ''
        try:
            r = requests.get('{}/api/v1/environment/stable/{}'.format(self.QLOUD_BASE_URL,
                                                                      balancer_info.get('environmentId')),
                             headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
            env_data = r.json()
        except Exception:
            return ''
        version = env_data.get('version')
        for comp in list(env_data.get('components').items()):
            if comp[1].get('environmentName') == env_id:
                try:
                    r = requests.get('{}/api/v1/runtime/{}/{}'.format(self.QLOUD_BASE_URL, comp[1].get('objectId'), version),
                                     headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
                    balancer_ins_data = r.json()
                except Exception:
                    continue
                return balancer_ins_data.get('network')
        return ''

    def handle(self, *args, **options):
        res = []
        try:
            r = requests.get('{}/api/v1/admin/report/molly'.format(self.QLOUD_BASE_URL),
                             headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
        except Exception:
            return
        envs = r.json()
        for e in envs:
            env_id = e.get('environmentId')
            users = []
            st_link = ''
            st = ''
            try:
                r = requests.get('{}/api/v1/project/{}'.format(self.QLOUD_BASE_URL, env_id.split('.')[0]),
                                 headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
                project_info = r.json()
            except Exception:
                continue
            else:
                routers_cache = dict()
                for app in project_info.get("applications"):
                    for e in app.get('environments'):
                        if env_id != e.get('objectId'):
                            continue
                        if e.get('status') != 'DEPLOYED':
                            continue
                        for link in app.get('metaInfo').get('links'):
                            if link.get('type') != 'tracker_startrek':
                                continue
                            st_link = link.get('url')
                            break
                        try:
                            r = requests.get('{}/api/v1/environment/stable/{}'.format(self.QLOUD_BASE_URL, env_id),
                                             headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
                            env_data = r.json()
                        except Exception:
                            continue
                        else:
                            network = ''
                            for router in env_data.get('routers', []):
                                if routers_cache.get(router.get('name')):
                                    network = routers_cache[router.get('name')]
                                else:
                                    network = routers_cache[router.get('name')] = self.get_balancer_net(router.get('name'))
                                if network:
                                    self.SRC_NETS.add(network)
        print(list(self.SRC_NETS))
        print(list(self.TARGET_BALANCERS))
