# -*- coding: utf-8 -*-
import json
import requests
import memcache
import zlib

from django.conf import settings
from django.core.management.base import BaseCommand


class Command(BaseCommand):
    help = ('update ABC services cache')

    def handle(self, *args, **options):
        headers = {'Authorization': 'OAuth ' + settings.OAUTH_TOKEN_FOR_STATIC}
        try:
            r = requests.get(settings.ABC_URL + '/api/v3/services/',
                             params={'page_size': 500, 'state__in': 'develop,supported,needinfo'},
                             headers=headers)
            response = r.json()
        except Exception:
            return
        cache = []
        while True:
            for service in response.get('results', []):
                cache.append({'id': service.get('id'), 'name': service.get('name')})
            if not response.get('next'):
                break
            response = requests.get(response.get("next"), headers=headers).json()

        mc = memcache.Client([settings.MEMCACHE_SERVER], debug=0)
        mc.set(b'molly_abc_cache', zlib.compress(json.dumps(cache).encode()))
