# -*- coding: utf-8 -*-
import json
import requests
import memcache
import zlib

from django.conf import settings
from django.core.management.base import BaseCommand
from django.db.models import Q

from molly_webui.models import Scan, ScanTask, Target, ProfilesTasks, ProfilesTargets, ScanProfile,\
    Vulnerability, VulnTicket, AuthProfile, FalsePositive, VulnerabilityType, CrasherStatus, TargetUriMap, \
    RequestSamples, CrasherChunk

from molly_webui.utils import upload_to_elliptics, join_by_domain, slugify_target_url, get_abc_id_by_slug, \
    get_abc_id_by_url, get_latest_aggregate, get_cgroup, get_abc_members, clean_antirobot_header


class Command(BaseCommand):
    help = ('Update Qloud Molly cache')
    QLOUD_BASE_URL = 'https://qloud-ext.yandex-team.ru'

    def get_balancer_net(self, env_id):
        try:
            r = requests.get('{}/api/v1/balancerL7/{}'.format(self.QLOUD_BASE_URL, env_id),
                             headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
            balancer_info = r.json()
        except Exception:
            return ''
        if not balancer_info.get('environmentId'):
            return ''
        try:
            r = requests.get('{}/api/v1/environment/stable/{}'.format(self.QLOUD_BASE_URL,
                                                                      balancer_info.get('environmentId')),
                             headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
            env_data = r.json()
        except Exception:
            return ''
        version = env_data.get('version')
        for comp in list(env_data.get('components').items()):
            if comp[1].get('environmentName') == env_id:
                try:
                    r = requests.get('{}/api/v1/runtime/{}/{}'.format(self.QLOUD_BASE_URL, comp[1].get('objectId'), version),
                                     headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
                    balancer_ins_data = r.json()
                except Exception:
                    continue
                return balancer_ins_data.get('network')
        return ''

    def handle(self, *args, **options):
        res = []
        try:
            r = requests.get('{}/api/v1/admin/report/molly'.format(self.QLOUD_BASE_URL),
                             headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
        except Exception:
            return
        envs = r.json()
        for e in envs:
            env_id = e.get('environmentId')
            users = []
            st_link = ''
            st = ''
            try:
                r = requests.get('{}/api/v1/project/{}'.format(self.QLOUD_BASE_URL, env_id.split('.')[0]),
                                 headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
                project_info = r.json()
            except Exception:
                continue
            else:
                routers_cache = dict()
                for app in project_info.get("applications"):
                    for e in app.get('environments'):
                        if env_id != e.get('objectId'):
                            continue
                        if e.get('status') != 'DEPLOYED':
                            continue
                        for link in app.get('metaInfo').get('links'):
                            if link.get('type') != 'tracker_startrek':
                                continue
                            st_link = link.get('url')
                            break
                        try:
                            r = requests.get('{}/api/v1/environment/stable/{}'.format(self.QLOUD_BASE_URL, env_id),
                                             headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
                            env_data = r.json()
                        except Exception:
                            continue
                        else:
                            network = ''
                            for router in env_data.get('routers', []):
                                if routers_cache.get(router.get('name')):
                                    network = routers_cache[router.get('name')]
                                else:
                                    network = routers_cache[router.get('name')] = self.get_balancer_net(router.get('name'))
                            for domain in env_data.get('domains', []):
                                if domain.get('type', '') == 'CDN->cdn-router':
                                    continue
                                if domain.get('url'):
                                    url = domain.get('url')
                                    break
                        if not url:
                            continue
                        try:
                            r = requests.get('{}/api/v1/access/{}'.format(self.QLOUD_BASE_URL,
                                                                          env_id.split('.')[0]),
                                             headers={'Authorization': settings.QLOUD_OAUTH_TOKEN})
                            data = r.json()
                        except Exception:
                            continue
                        else:
                            acls = data.get('acls', [])
                            for acl in acls:
                                if acl.get('grantedObjectLevel') == 'Global' or acl.get('type') != 'USER':
                                    continue
                                username = acl.get('user')
                                if not username or username.startswith('robot-') or \
                                        username.startswith('zomb-'):
                                    continue
                                users.append(username)
                            if st_link:
                                st = st_link.strip('/').split('/')[-1]
                            res.append({'id': env_id, 'url': url, 'st_queue': st, 'users': users, 'network': network})
                            break
        qloud_res = []
        for item in res:
            if not item.get('id'):
                continue
            target = None
            #XXX: those are super ugly euristics
            filters = Q(antirobot_uid=item.get('id'))
            filters.add(Q(antirobot_uid=clean_antirobot_header(item.get('id'))), Q.OR)
            filters.add(Q(antirobot_uid='molly-'+clean_antirobot_header(item.get('id'))), Q.OR)
            targets = Target.objects.filter(filters)[:1]
            if targets:
                target = targets[0]
            else:
                # retry, but this is ugly
                scan_qs = Scan.objects.filter(slug=slugify_target_url(item.get('url'))).exclude(target__id=0).order_by('-id')[:2]
                for sc in scan_qs:
                    try:
                        target = sc.target
                    except Exception:
                        pass
                    else:
                        break
            users = item.get('users', [])
            info = {'id': item.get('id'), 'url': item.get('url')}
            if target:
                if target.parent:
                    target = target.parent
                users = list(set(users + [u.username for u in target.users.all()]))
                info['st_queue'] = target.st_queue
                info['target'] = target.name
                info['max_rps'] = target.rps_limit
                info['users'] = users
            qloud_res.append(info)
        qloud_envs = [list(x.items()).pop()[1] for x in qloud_res]
        qs = Target.objects.filter(antirobot_uid__isnull=False, parent__isnull=True)
        for t in qs:
            if not t.antirobot_uid or t.antirobot_uid in qloud_envs:
                continue
            if t.antirobot_uid == 'molly-':
                continue
            qloud_res.append({'id': t.antirobot_uid, 'url': t.url,
                              'users': [u.username for u in t.users.all()],
                              'st_queue': t.st_queue, 'target': t.name,
                              'max_rps': t.rps_limit})
        mc = memcache.Client([settings.MEMCACHE_SERVER], debug=0)
        mc.set('molly_qloud_cache', zlib.compress(json.dumps(qloud_res)))
