# -*- coding: utf-8 -*-

from django.utils import translation
from django.conf import settings


def show_toolbar(request):
    """
    Default function to determine whether to show the toolbar on a given page.
    """
    if request.is_ajax():
        return False

    return bool(settings.DEBUG)


class AuditMiddleware(object):
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        response = self.get_response(request)
        if not hasattr(request, 'user') or not request.user:
            return response
        if request.user.is_authenticated:
            response["x-yandex-user"] = request.user.username.encode('utf-8')
        return response
