import requests

class Metrics(object):
    def __init__(self, url):
        self.url = url
        self.session = None

    def maybe_init_session(self):
        self.session = requests.Session()
        retry_adapter = requests.adapters.HTTPAdapter(max_retries=3)
        
        self.session.mount("http://", retry_adapter)
        self.session.mount("https://", retry_adapter)
        
    def try_send_metric(self, metric_name, count=1):
        """Try to send metrics, no throw exception if error"""
        try:
            self.session.post(self.url, data=dict(event=metric_name, count=count))
        except requests.exceptions.RequestException:
            pass
