#-*- coding: utf-8 -*-
from django.core.mail import EmailMultiAlternatives
from django.core.mail import send_mail
from django.conf import settings
from django.template.loader import render_to_string

from logging import getLogger

logger = getLogger(__name__)


def send(subj, message, email):
    if not email:
        email = settings.FALLBACK_REPORT_EMAIL
    try:
        send_mail(subj, message, email, [email], fail_silently=False)
    except Exception as e:
        logger.error('Can not send mail: %s' % e)
        return False
    return True


def notify(user, target, scan_id):
    report_link = '%s/show_report/%s/' % (
        settings.APP_URL,
        scan_id, )
    message = 'Scan %s was finished.  %s' % (target, report_link)
    subj = 'Scan %s was finished' % target
    return send(subj, message, user.email)


def notify_about_fail(user, target, scan_id):
    log_link = '%s/show_report_txt/%s/' % (
        settings.APP_URL,
        scan_id, )
    message = ('Scan %s was not finished successfully. Show log file for '
               'more details %s' % (target, log_link))
    subj = 'Scan %s was failed' % target
    return send(subj, message, user.email)


def send_message(to_email, template, subject, data, sender_email=''):
    to = None
    if isinstance(to_email, str):
        to = [to_email]
    if isinstance(to_email, list):
        to = to_email

    if not sender_email:
        sender_email = settings.EMAIL_HOST_USER

    if not to:
        return False

    html_content = render_to_string(template, data)
    text_content = render_to_string(template, data)
    msg = EmailMultiAlternatives(subject, text_content, sender_email, to, headers={'Reply-To': sender_email})
    msg.attach_alternative(html_content, "text/html")
    msg.content_subtype = "html"
    msg.send(fail_silently=True)
    return True
