#-*- coding: utf-8 -*-
from django.conf import settings
from molly_webui.notification.send_mail import send
from molly_webui.models import Scan
from molly_webui.models import Vulnerability

def notify(user, target, scan_id):
    scan = Scan.objects.get(pk=scan_id)
    vuln = Vulnerability.objects.filter(scan=scan)
    if not vuln:
        return True
    report_link = '%s/show_report/%s/' % (
        settings.APP_URL,
        scan_id,
    )
    message = ('Scan %s found %s vulnerability(ies).\n Show report'
              ' for more details %s' % (target, len(vuln), report_link))
    subj = 'Scan %s found vulnerabilities' % target
    return send(subj, message, user.email)
