import json
import requests
import requests.packages.urllib3
from datetime import datetime

class Solomon(object):
    def __init__(self, push_url='https://solomon.yandex.net/api/v2/push',
                 project='',
                 cluster='',
                 service='',
                 token='',
                 timeout=60.0):
        self.timeout = timeout
        self.push_url = push_url
        self._params = {'project': project, 'cluster': cluster, 'service': service}
        self._headers = {
                        'Authorization': 'OAuth {}'.format(token),
                        'Content-Type': 'application/json',
                        'Accept': 'application/json'
        }
        self._session = self._make_session()
        self._sensors = []

    def _make_session(self, retries=3, backoff_factor=0.1, pool_connections=1, pool_maxsize=10):
        session = requests.Session()
        session.headers.update({'Content-Type': 'application/json'})
        retry = requests.packages.urllib3.Retry(
            total=retries,
            backoff_factor=backoff_factor,
            status_forcelist=[429, 500, 502, 503, 504],
        )
        adapter = requests.adapters.HTTPAdapter(
            max_retries=retry,
            pool_connections=pool_connections,
            pool_maxsize=pool_maxsize,
        )
        session.mount('http://', adapter)
        session.mount('https://', adapter)
        return session

    def push_sensor(self, key, value, target_id):
        self._sensors.append({
            'labels': {"name": key, 'target_id': target_id},
            'value': value,
            'ts': datetime.utcnow().strftime('%Y-%m-%dT%H:%M:%SZ')
        })

    # XXX: this is ugly but its ok for now
    def flush(self):
        if not self._sensors:
            return
        try:
            data = json.dumps({"sensors": self._sensors})
            response = self._session.post(
                self.push_url,
                params=self._params,
                data=data,
                timeout=self.timeout,
                headers=self._headers,
            )
        except Exception as e:
            pass
        else:
            self._sensors = []
        return
