#-*- coding: utf-8 -*-
import os.path
from django.utils.translation import ugettext_lazy as _

DEBUG = False
TEMPLATE_DEBUG = DEBUG

# ---------- Personal settings -----------------
ADMINS = (
    ('Eldar Zaitov', 'ezaitov@yandex-team.ru'),
)

try:
    from db_settings import *
except ImportError:
    import sys
    print('WARNING: No db_settings found', file=sys.stderr)

# Full url, just for link in notification email
APP_URL = 'https://molly.yandex-team.ru'

# ----------- Advanced settings--------------
MANAGERS = ADMINS

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# On Unix systems, a value of None will cause Django to use the same
# timezone as the operating system.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'Europe/Moscow'

LANGUAGES = (
    ('ru', _('Russian')),
    ('en', _('English')),
)

# Path for localisation
_PATH = os.path.abspath(os.path.dirname(__file__))
LOCALE_PATHS = (os.path.join(_PATH, 'locale'),)

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'ru-RU'
#LANGUAGE_CODE = 'en-EN'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = False
# If you set this to False, Django will not format dates, numbers and
# calendars according to the current locale
USE_L10N = True

# Default charset to use for all HttpResponse objects
DEFAULT_CHARSET = 'utf-8'
# Set default language for interfase. This value must be in LANGUAGES tuple
DEFAULT_LANGUAGE = 'en'

# Absolute filesystem path to the directory that will hold user-uploaded files.
# Example: "/home/media/media.lawrence.com/media/"
# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash.
# Examples: "http://media.lawrence.com/media/", "http://example.com/media/"
MEDIA_URL = '/media/'
MEDIA_ROOT = (os.path.join(_PATH, 'media'),)

# URL prefix for static files.
# Example: "http://media.lawrence.com/static/"
STATIC_URL = '/static/'

# Additional locations of static files
STATICFILES_DIRS = (
    # Put strings here, like "/home/html/static" or "C:/www/django/static".
    # Always use forward slashes, even on Windows.
    # Don't forget to use absolute paths, not relative paths.
)

STATIC_ROOT = os.path.join(_PATH, 'static')

SECRET_KEY = 'set by extra_settings.py'

ROOT_URLCONF = 'molly_webui.urls'

CELERY_WORKER_CONCURRENCY = 4
CELERYD_LOG_LEVEL = "INFO"

# Settings for email notification
EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
EMAIL_HOST = 'outbound-relay.yandex.net'
EMAIL_PORT = 25
EMAIL_HOST_USER = 'molly@yandex-team.ru'
EMAIL_HOST_PASSWORD = ''
EMAIL_USE_TLS = False
EMAIL_TIMEOUT = 5

INSTALLED_APPS = ()
try:
     from local_settings import *
except Exception as e:
    print('Can not find local settings: %s' % e)

try:
     from extra_settings import * # optional settings with your own auth
except Exception as e:
    print('Can not find extra settings: %s' % e)

MIDDLEWARE = (
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'molly_webui.middleware.AuditMiddleware'
)


INSTALLED_APPS += (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.admin',
    'django_yauth',
    'rest_framework',
    'molly_webui',
    'molly_webui.api',
    'bootstrap3',
    'sanitizer'
)


TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [
            os.path.join(_PATH, 'templates'),
            '/usr/local/lib/python3.6/dist-packages/django/contrib/admin/templates',
        ],
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.i18n',
                'django.template.context_processors.media',
                'django.contrib.auth.context_processors.auth',
                'django_yauth.context.yauth',
                'django.template.context_processors.static',
                'django.template.context_processors.request',
                'django.contrib.messages.context_processors.messages',
            ],
            # List of callables that know how to import templates from various sources.
            'loaders': [
                'django.template.loaders.filesystem.Loader',
                'django.template.loaders.app_directories.Loader',
            ]
        },
    }
]


SANITIZER_ALLOWED_TAGS = ['ul', 'li', 'b', 's', 'strong', 'i', 'pre', 'br', 'tr', 'td', 'th', 'table', 'strong']
SANITIZER_ALLOWED_ATTRIBUTES = []

CELERY_TASK_SERIALIZER = 'pickle'
CELERY_ACCEPT_CONTENT = ['json', 'application/text', 'application/x-python-serialize']

MOLLY_SPOOL_PATH = '/var/local/molly'

# scanner subprocess poll period in seconds
SCANNER_POLL_PERIOD = 15
ST_USER_AGENT = 'MollyRobot'
ST_DEFAULT_QUEUE = 'SECALERTS'

AUTH_USER_MODEL = 'auth.User'

YAUTH_TYPE = 'intranet'
YAUTH_BLACKBOX_INSTANCE = blackbox.XmlBlackbox(url='https://blackbox.yandex-team.ru/blackbox',
                                               tvm2_client_id=YAUTH_TVM2_CLIENT_ID,
                                               tvm2_secret=YAUTH_TVM2_SECRET,
                                               blackbox_client=YAUTH_TVM2_BLACKBOX_MAP['blackbox.yandex-team.ru'])

PASSPORT_TLDS = (
    'ru',
    'com.tr',
    'kz',
    'ua',
    'by',
    'az',
    'com.am',
    'com.ge',
    'com.ua',
    'co.il',
    'kg',
    'lt',
    'lv',
    'md',
    'tj',
    'tm',
    'uz',
    'fr',
    'ee',
    'fi',
    'pl',
    'eu'
)

PASSPORT_DEFAULT_TLD = 'ru'

SOLOMON_PROJECT_ID = 'molly'
SOLOMON_CLUSTED_ID = 'default'
SOLOMON_METRICS_SERVICE = 'scan_metrics'

CA_FILE = '/etc/ssl/certs/ca-certificates.crt'

SILENCED_SYSTEM_CHECKS = [
    # Подавляем 'django.contrib.auth.middleware.AuthenticationMiddleware'
    # must be in MIDDLEWARE in order to use the admin application.
    # потому что авторизацией рулит yauth.
    'admin.E408',
]

# uncomment for local testing
# from local_dev_settings import *
