upstream molly_upstream {
    server molly-collector.sec.yandex.net:443 max_fails=0;
    keepalive 2; # 2 keepalive connections to molly
}


server {
    listen       80;
    server_name  {{ domain }};

    location / {
        antirobot_request /molly;
        ...
        proxy_pass http://your_application;
    }

    location = /molly {
        internal;
        antirobot_request off; # fool-protection
        proxy_connect_timeout   20ms;
        proxy_send_timeout      10ms;
        proxy_read_timeout      3ms;
        proxy_set_header Host "molly-collector.common.yandex.net";
        proxy_set_header X-Host-Y $host;
        proxy_set_header X-Antirobot-Service-Y "{{ uid }}";
        proxy_pass https://molly_upstream$request_uri;
    }
}