from django import template
from django.conf import settings
import requests

register = template.Library()

@register.filter(name='wikimarkup')
def wikimarkup(value):
    headers = {'User-Agent': 'Molly'}
    data = {'text': value}
    try:
        resp = requests.post(settings.WIKIFORMATTER_URL, headers=headers, data=data)
    except:
        return 'Something goes wrong, please contact product-security@yandex-team.ru'
    return resp.text
