# -*- coding: utf-8 -*-


from django.views.static import serve as st
from django.conf.urls import include
from django.conf.urls import url
from django.contrib import admin
from django.conf import settings

from .views import APITokenView, AuthProfileView, ScanListView, CallSibView, HTTPTransactionView, \
    TargetMapView, CrasherDashboardView, TargetListView, TargetEditView, IndexView, \
    StQueueSuggest, AntirobotWizardView, MergeTargetView, ReportView, CancelScanView, StTicketView, \
    VulnFalsePositiveView, VulnTypeFalsePositiveView, ScanTargetEditView, NewTargetView, MDSProxyView

# backward compatibility
from .api.views import StWebhookHandler, TargetMapExportView

admin.autodiscover()

urlpatterns = [
    url('^$', IndexView.as_view(), name='index'),
    url(r'^api/', include('molly_webui.api.urls')),
    # TODO: remove it after all the old tickets closed
    url(r'^st-webhook-handler/?$', StWebhookHandler.as_view(), name='old_st_webhook_handler'),

    url('^post_ticket/?$', StTicketView.as_view(), name='create_ticket'),
    url('^report/(?P<scan_uid>[\w-]+)/?$', ReportView.as_view(), name='show_report'),
    url('^scan/(?P<scan_uid>[\w-]+)/cancel/?$', CancelScanView.as_view(), name='cancel_scan'),
    url('^scan/(?P<scan_uid>[\w-]+)/target/?$', ScanTargetEditView.as_view(), name='edit_scan_target'),
    url('^mark_vuln_false_positive/?$', VulnFalsePositiveView.as_view(), name='mark_vuln_as_fp'),
    url('^mark_vulntype_false_positive/?$', VulnTypeFalsePositiveView.as_view(), name='mark_vulntype_as_fp'),
    url('^http_transaction/(?P<vuln_id>[\w-]+)/?$', HTTPTransactionView.as_view(), name='vuln_http_transaction'),

    url(r'^scan/?$', ScanListView.as_view(), name='scan_list'),
    url(r'^token/?$', APITokenView.as_view(), name='new_api_token'),
    url(r'^auth_profile/?$', AuthProfileView.as_view(), name='auth_profiles_list'),
    url(r'^auth_profile/(?P<profile_id>[\w-]+)/?$', AuthProfileView.as_view(), name='auth_profile_editor'),
    url('^call_is/?$', CallSibView.as_view(), name='call_is'),

    url(r'^targets/?$', TargetListView.as_view(), name='target_list_view'),
    url(r'^targets/merge/?$', MergeTargetView.as_view(), name='target_merge_view'),
    url(r'^targets/(?P<target_id>\d+)/?$', TargetEditView.as_view(), name='target_details_view'),
    url(r'^targets/new/?$', NewTargetView.as_view(), name='target_create_view'),

    url(r'^sitemap/export/(?P<uid>[\w-]+)/?$', TargetMapExportView.as_view(), name='target_map_export_view'),
    url(r'^sitemap/?$', TargetMapView.as_view(), name='target_map_list_view'),
    url(r'^sitemap/(?P<map_id>[\d-]+)/?$', TargetMapView.as_view(), name='target_map_editor_view'),

    url(r'^crasher/?$', CrasherDashboardView.as_view(), name='crasher_dashboard'),
    url(r'^suggest/queue$', StQueueSuggest.as_view(), name='st_queue_suggester'),
    url(r'^collector/gen', AntirobotWizardView.as_view(), name='antirobot_wizard'),

    url(r'admin/', admin.site.urls),

    url(r'^static/(?P<path>.*)$', st, {'document_root': settings.STATIC_ROOT}),
    url(r'^elliptics-proxy/(?P<prefix>\d+)/(?P<postfix>[\w-]+)/?$', MDSProxyView.as_view(), name='mds_proxy_view'),
]
