package main

import (
	"fmt"
	"os"

	"a.yandex-team.ru/security/osquery/extensions/gosecure"
)

func main() {
	status, err := gosecure.GetAppArmorStatus()
	if err != nil {
		fmt.Println(err)
		os.Exit(1)
	}

	fmt.Println("Loaded: ", status.Enabled)
	fmt.Println("SecurityFS Path: ", status.SecurityFsPath)
	fmt.Println("Profiles:")
	for k, v := range status.Profiles {
		fmt.Println("Name:", k, "Status:", v)
	}
	fmt.Println("Confined Processes: ")
	for _, v := range status.ConfinedProcesses {
		fmt.Println("Pid:", v.Pid, "Profile:", v.Profile, "Mode:", v.Mode)
	}
}
