package main

import (
	"fmt"
	"log"
	"strings"

	"github.com/godbus/dbus/v5"

	gosecuredbus "a.yandex-team.ru/security/osquery/extensions/gosecure/dbus"
)

func handler(s *dbus.Signal) {
	if s != nil {
		message := []string{
			"Name: " + s.Name,
			"Sender: " + s.Sender,
			"Path: " + string(s.Path),
			fmt.Sprintf("Body: %v", s.Body),
		}

		fmt.Println(strings.Join(message, ", "))
	}
}

/*
[evs@evs-pc cmd]$ sudo ./cmd
{:1.3 /org/freedesktop/login1 org.freedesktop.login1.Manager.UserNew [1001 /org/freedesktop/login1/user/_1001]}
{:1.3 /org/freedesktop/login1 org.freedesktop.login1.Manager.SessionNew [21 /org/freedesktop/login1/session/_321]}
{:1.3 /org/freedesktop/login1 org.freedesktop.login1.Manager.SessionRemoved [21 /org/freedesktop/login1/session/_321]}
{:1.3 /org/freedesktop/login1 org.freedesktop.login1.Manager.UserRemoved [1001 /org/freedesktop/login1/user/_1001]}
{:1.3 /org/freedesktop/login1 org.freedesktop.login1.Manager.PrepareForSleep [true]}
{:1.3 /org/freedesktop/login1 org.freedesktop.login1.Manager.PrepareForSleep [false]}
Name: org.freedesktop.login1.Manager.PrepareForShutdown, Sender: :1.3, Path: /org/freedesktop/login1, Body: [true]
*/

func main() {
	l, err := gosecuredbus.NewListener(handler)
	if err != nil {
		log.Fatal(err)
	}

	b := gosecuredbus.NewBuffer(1024)
	if err := l.Start(b); err != nil {
		log.Fatal(err)
	}
}
