package main

import (
	"fmt"
	"os"

	"a.yandex-team.ru/security/osquery/extensions/gosecure/dbus/logind"
	"a.yandex-team.ru/security/osquery/extensions/gosecure/dbus/systemd"
)

func main() {
	fmt.Println("Files:")
	files, err := systemd.ListUnitFiles()
	if err != nil {
		fmt.Println(err.Error())
		os.Exit(1)
	}

	for _, fl := range files {
		fmt.Println("Path:", fl.Path)
		fmt.Println("Status:", fl.Status)
	}

	units, err := systemd.ListUnits()
	if err != nil {
		fmt.Println(err.Error())
		os.Exit(1)
	}

	fmt.Println("Units:")
	for _, unit := range units {
		fmt.Println("Unit:", unit.Name)
		fmt.Println("Load State:", unit.LoadState)
		fmt.Println("Active State:", unit.ActiveState)
	}

	fmt.Println("Jobs:")
	jobs, err := systemd.ListJobs()
	if err != nil {
		fmt.Println(err.Error())
	}
	for _, job := range jobs {
		fmt.Println("Job:", job)
	}

	paths, err := systemd.UnitPath()
	if err != nil {
		fmt.Println(err.Error())
	}
	fmt.Println("UnitPath:", paths)

	session, err := logind.GetSessionInfo("/org/freedesktop/login1/session/_31")
	if err != nil {
		fmt.Println("error", err.Error())
	} else {
		fmt.Println(session.Name)
	}

	sessions, err := logind.GetAllSessionObjects()
	if err != nil {
		fmt.Println(err.Error())
	}

	fmt.Println(sessions)
}
