package dbus

import (
	"sync"
	"time"

	godbus "github.com/godbus/dbus/v5"
)

type DbusEvent struct {
	Timestamp int64
	Signal    *godbus.Signal
}

type Buffer struct {
	buffer      []*DbusEvent
	mxt         *sync.RWMutex
	reserveSize uint
}

func NewBuffer(reserveSize uint) *Buffer {
	return &Buffer{
		make([]*DbusEvent, 0, reserveSize),
		&sync.RWMutex{},
		reserveSize,
	}
}

func (b *Buffer) Append(s *godbus.Signal) {
	b.mxt.Lock()
	defer b.mxt.Unlock()

	b.buffer = append(b.buffer, &DbusEvent{time.Now().UnixNano(), s})
}

func (b *Buffer) GetAll() []*DbusEvent {
	b.mxt.Lock()
	defer b.mxt.Unlock()

	result := b.buffer
	b.buffer = make([]*DbusEvent, 0, b.reserveSize)

	return result
}
