//go:build linux
// +build linux

package gosecure

import (
	"fmt"
	"io/ioutil"
	"os"
	"strings"

	"a.yandex-team.ru/library/go/core/xerrors"
)

const (
	Mounts     = "/proc/mounts"
	SecurityFs = "securityfs"
)

func FindSecurityFs() (string, error) {
	return findSecurityFs(Mounts)
}

func findSecurityFs(filename string) (string, error) {
	data, err := ioutil.ReadFile(filename)
	if err != nil {
		return "", err
	}
	lines := strings.Split(string(data), "\n")
	for num := range lines {
		if lines[num][:len(SecurityFs)] == SecurityFs {
			tokens := strings.Split(lines[num], " ")
			if len(tokens) < 2 {
				return "", fmt.Errorf("incorrect format of %s file", filename)
			}

			if info, err := os.Stat(tokens[1]); os.IsNotExist(err) {
				return "", fmt.Errorf("%s not found", SecurityFs)
			} else {
				if info.IsDir() {
					return tokens[1], nil
				}
			}
		}
	}

	return "", xerrors.New("securityfs not found")
}
