package container

// Set impl in Go, version 100500.
type StringSet struct {
	m map[string]struct{}
}

func MakeStringSet(slice []string) StringSet {
	ret := StringSet{m: map[string]struct{}{}}
	for _, s := range slice {
		ret.m[s] = struct{}{}
	}
	return ret
}

func (s *StringSet) Contains(str string) bool {
	_, ok := s.m[str]
	return ok
}

func (s *StringSet) Insert(str string) bool {
	if s.m == nil {
		s.m = map[string]struct{}{}
	}
	_, ok := s.m[str]
	if !ok {
		s.m[str] = struct{}{}
	}
	return !ok
}

func (s *StringSet) Remove(str string) {
	delete(s.m, str)
}
