package platform

// A simpler alternative to bytes.Buffer, which is easier to work with.
type byteBuffer struct {
	buf    []byte
	offset int
	length int
}

func newByteBuffer(size int) *byteBuffer {
	return &byteBuffer{
		buf:    make([]byte, size),
		offset: 0,
		length: 0,
	}
}

func (buf *byteBuffer) reset() {
	buf.offset = 0
	buf.length = 0
}

func (buf *byteBuffer) remaining() int {
	return buf.length - buf.offset
}

func (buf *byteBuffer) readSlice(n int) []byte {
	ret := buf.buf[buf.offset : buf.offset+n]
	buf.offset += n
	return ret
}
