package platform

type FileNotifyFn func(path string, isDir bool)
type FileMoveNotifyFn func(oldPath string, newPath string, isDir bool)

type FileNotifier interface {
	Add(path string) error
	// NOTE: All callbacks should check that file exists and is not a directory/pipe/device/socket.
	// Callback will be called when file attributes change.
	SetOnAttrib(callback FileNotifyFn)
	// Callback will be called on each file deletion.
	SetOnDelete(callback FileNotifyFn)
	// Callback will be called on each file modification.
	SetOnModify(callback FileNotifyFn)
	// Callback will be called on moving files or directories.
	SetOnMove(callback FileMoveNotifyFn)
}
