//go:build linux
// +build linux

package platform

import (
	"fmt"
	"io/ioutil"
	"log"
	"strconv"
	"strings"
)

const (
	inotifyLimit = 100000
)

func NewNotifier(verbose bool) (FileNotifier, error) {
	// return NewFaNotifier()
	return NewINotifier(verbose)
}

// Increase user_watch_limit for inotify.
func BumpNotifyLimit() error {
	const sysPath = "/proc/sys/fs/inotify/max_user_watches"
	contents, err := ioutil.ReadFile(sysPath)
	if err != nil {
		return fmt.Errorf("could not read inotify limit: %v", err)
	}
	curLimit, err := strconv.Atoi(strings.TrimSpace(string(contents)))
	if err != nil {
		return fmt.Errorf("%s contents is not an integer: %s", sysPath, string(contents))
	}
	if curLimit >= inotifyLimit {
		log.Printf("Current inotify limit: %d, big enough\n", curLimit)
		return nil
	}

	newContents := []byte(strconv.Itoa(inotifyLimit))
	err = ioutil.WriteFile(sysPath, newContents, 0)
	if err != nil {
		return fmt.Errorf("could not increase inotify limit: %v", err)
	}

	log.Printf("Increase inotify limit to %d\n", inotifyLimit)
	return nil
}
