//go:build !darwin && !linux
// +build !darwin,!linux

package platform

import (
	"os"
	"os/signal"
	"syscall"
	"time"
)

func GetDefaultConfigPath() string {
	return ""
}

func Init(verbose bool) {
}

func WaitForSignal() {
	gracefulStop := make(chan os.Signal, 1)

	signal.Notify(gracefulStop, syscall.SIGINT)
	<-gracefulStop
}

func SelfLowerPriority() {
}

func ShouldIgnorePath(path string) bool {
	return false
}

func IsExecutable(fileInfo os.FileInfo) bool {
	return true
}

func GetRealPath(path string) (string, error) {
	return "", nil
}

func GetFileCreationTime(path string, fileInfo os.FileInfo) (time.Time, error) {
	return time.Time{}, nil
}

func OpenSequential(path string) (*os.File, error) {
	return os.Open(path)
}
