package platform

import "time"

// Go 1.15 added the proper Reset() method, but for now we have to support Go 1.14. The ticker must be
// Started/Stopped in the same goroutine to prevent concurrent updates to C.

type RestartableTicker struct {
	period time.Duration

	ticker *time.Ticker
	C      <-chan time.Time
}

func NewRestartableTicker(period time.Duration) RestartableTicker {
	return RestartableTicker{period: period}
}

func (t *RestartableTicker) Start() bool {
	if t.ticker != nil {
		return false
	}
	t.ticker = time.NewTicker(t.period)
	t.C = t.ticker.C
	return true
}

func (t *RestartableTicker) Stop() bool {
	if t.ticker == nil {
		return false
	}
	t.ticker.Stop()
	t.ticker = nil
	t.C = nil
	return true
}
