#!/bin/bash

set -ex

REMOTE_HOST=$1
IS_CLOUD=${2:-}

if [[ $REMOTE_HOST == "" ]]; then
  echo "Usage: $0 remote-host"
  exit 1
fi

if [[ $IS_CLOUD == "" ]]; then
  if [[ $REMOTE_HOST == *".cloud.yandex.net" ]] || [[ $REMOTE_HOST == *".cloud-preprod.yandex.net" ]] || [[ $REMOTE_HOST == *".cloud-testing.yandex.net" ]]; then
    IS_CLOUD="y"
  fi
fi

TIMESTAMP=`date +"%s"`
FILENAME=block-$TIMESTAMP.pprof
COMMAND="curl --output $FILENAME http://localhost:6060/debug/pprof/block"
if [[ $IS_CLOUD == "y" ]]; then
  pssh run "$COMMAND" $REMOTE_HOST
  pssh scp $REMOTE_HOST:$FILENAME .
  pssh run "rm $FILENAME" $REMOTE_HOST
else
  ssh $REMOTE_HOST "$COMMAND"
  scp $REMOTE_HOST:$FILENAME .
  ssh $REMOTE_HOST "rm $FILENAME"
fi
go tool pprof -http=: $FILENAME
