#!/bin/bash

set -ex

REMOTE_HOST=$1
PROFILE_LENGTH=${2:-30}
IS_CLOUD=${3:-}

if [[ $REMOTE_HOST == "" ]]; then
  echo "Usage: $0 remote-host"
  exit 1
fi

if [[ $IS_CLOUD == "" ]]; then
  if [[ $REMOTE_HOST == *".cloud.yandex.net" ]] || [[ $REMOTE_HOST == *".cloud-preprod.yandex.net" ]] || [[ $REMOTE_HOST == *".cloud-testing.yandex.net" ]]; then
    IS_CLOUD="y"
  fi
fi

TIMESTAMP=`date +"%s"`
FILENAME=profile-$TIMESTAMP.pprof
COMMAND="curl --output $FILENAME http://localhost:6060/debug/pprof/profile?seconds=$PROFILE_LENGTH"
if [[ $IS_CLOUD == "y" ]]; then
  pssh run "$COMMAND" $REMOTE_HOST
  pssh scp $REMOTE_HOST:$FILENAME .
  pssh run "rm $FILENAME" $REMOTE_HOST
else
  ssh $REMOTE_HOST "$COMMAND"
  scp $REMOTE_HOST:$FILENAME .
  ssh $REMOTE_HOST "rm $FILENAME"
fi
go tool pprof -http=: $FILENAME
