package main

import (
	"context"
	"strconv"

	"github.com/kolide/osquery-go/plugin/table"

	"a.yandex-team.ru/security/osquery/extensions/gosecure"
)

func AppArmorConfinedProcessesTable() []table.ColumnDefinition {
	return []table.ColumnDefinition{
		table.BigIntColumn("pid"),
		table.TextColumn("profile"),
		table.TextColumn("status"),
	}
}

func GenerateConfinedProcessesStatus(ctx context.Context, queryCtx table.QueryContext) ([]map[string]string, error) {
	status, err := gosecure.GetProcessesConfinementStatus()
	if err != nil {
		return []map[string]string{}, err
	}

	result := make([]map[string]string, len(status))
	for i := range status {
		result[i] = map[string]string{
			"pid":     strconv.FormatUint(status[i].Pid, 10),
			"profile": string(status[i].Profile),
			"status":  string(status[i].Mode),
		}
	}

	return result, nil
}
