package main

import (
	"context"

	"github.com/kolide/osquery-go/plugin/table"

	"a.yandex-team.ru/security/osquery/extensions/gosecure"
)

func LsmsTable() []table.ColumnDefinition {
	return []table.ColumnDefinition{
		table.TextColumn("name"),
	}
}

func GenerateEnabledLsms(ctx context.Context, queryCtx table.QueryContext) ([]map[string]string, error) {
	lsms, err := gosecure.GetEnabledLSMs()
	if err != nil {
		return nil, err
	}

	result := make([]map[string]string, len(lsms))
	for i := range lsms {
		result[i] = map[string]string{
			"name": lsms[i],
		}
	}

	return result, nil
}
