package main

import (
	"context"

	"github.com/kolide/osquery-go/plugin/table"

	"a.yandex-team.ru/security/osquery/extensions/gosecure"
)

func AppArmorProfilesTable() []table.ColumnDefinition {
	return []table.ColumnDefinition{
		table.TextColumn("profile"),
		table.TextColumn("mode"),
	}
}

func GenerateAppArmorProfiles(ctx context.Context, queryContext table.QueryContext) ([]map[string]string, error) {
	profiles, err := gosecure.GetAppArmorProfiles()
	if err != nil {
		return []map[string]string{}, err
	}

	result := make([]map[string]string, 0, len(profiles))
	for k, v := range profiles {
		result = append(result, map[string]string{"profile": string(k), "mode": string(v)})
	}
	return result, nil
}
