package main

import (
	"context"

	"github.com/kolide/osquery-go/plugin/table"

	"a.yandex-team.ru/security/osquery/extensions/gosecure"
)

func SysctlTable() []table.ColumnDefinition {
	return []table.ColumnDefinition{
		table.TextColumn("key"),
		table.TextColumn("value"),
	}
}

func GenerateSysctlData(ctx context.Context, queryCtx table.QueryContext) ([]map[string]string, error) {
	sysctls, err := gosecure.AllSysctls()
	if err != nil {
		return nil, err
	}

	result := make([]map[string]string, len(sysctls))
	i := 0
	for k, v := range sysctls {
		result[i] = map[string]string{
			"key":   k,
			"value": v,
		}
		i++
	}

	return result, nil
}
