package main

import (
	"context"
	"fmt"

	"github.com/kolide/osquery-go/plugin/table"

	"a.yandex-team.ru/security/osquery/extensions/gosecure"
)

func YamaTable() []table.ColumnDefinition {
	return []table.ColumnDefinition{
		table.IntegerColumn("ptrace_scope"),
	}
}

func GenerateYamaPTraceScope(ctx context.Context, queryCtx table.QueryContext) ([]map[string]string, error) {
	scope, err := gosecure.GetYAMAPtraceScope()
	if err != nil {
		return nil, err
	}

	return []map[string]string{
		{
			"ptrace_scope": fmt.Sprintf("%d", scope),
		},
	}, nil
}
