package main

import (
	"encoding/csv"
	"log"
	"os"

	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/compute"
	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/conductor"
	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/config"
	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/ichecker"
	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/misc"
	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/splunk"
)

type HostStatus struct {
	Conductor        string
	ComputeStatus    string
	ComputeCreatedAt string
	SplunkLastSeen   string
}

func formCsv(hosts map[string]*HostStatus) (csvArray [][]string) {
	csvArray = [][]string{{"Hostname", "Conductor", "ComputeStatus", "ComputeCreatedAt", "SplunkLastSeen"}}
	for host, status := range hosts {
		csvArray = append(csvArray, []string{host, status.Conductor, status.ComputeStatus, status.ComputeCreatedAt, status.SplunkLastSeen})
	}
	return
}

func saveCsv(csvArray [][]string, path string) {
	log.Println("saving csv...")
	file, err := os.Create(path)
	misc.ErrorCheck(err)
	defer func() { misc.ErrorCheck(file.Close()) }()

	writer := csv.NewWriter(file)
	defer writer.Flush()
	defer log.Println("saved to ", path)

	for _, value := range csvArray {
		err := writer.Write(value)
		misc.ErrorCheck(err)
	}
}

func saveCsvDryRun(csvArray [][]string, path string) {
}

func main() {
	hosts := make(map[string]*HostStatus)

	// cloud-preprod.yandex.net
	// yandexcloud.net
	// *cloud.yandex*

	splunkQuery := (`| tstats latest(_time) as latest where (index=yhids earliest=-1d) by host | convert ctime(latest) | search host IN (*cloud-preprod.yandex.net, *yandexcloud.net)`)

	conductorResults := conductor.FetchInstances()
	// conductorResults := conductor.FetchInstancesDryRun()
	splunkResults := splunk.Search(splunkQuery)
	// splunkResults := splunk.SearchDryRun(splunkQuery)
	computeResults := compute.FetchInstances()
	// computeResults := compute.FetchInstancesDryRun()
	trueString := "true"

	for i := range conductorResults {
		if _, ok := hosts[conductorResults[i]]; ok {
			hosts[conductorResults[i]].Conductor = trueString
		} else {
			hosts[conductorResults[i]] = &HostStatus{
				Conductor: trueString,
			}
		}
	}

	for k, v := range computeResults {
		if _, ok := hosts[k]; ok {
			hosts[k].ComputeStatus = v.Status
			hosts[k].ComputeCreatedAt = v.CreatedAt
		} else {
			hosts[k] = &HostStatus{
				ComputeStatus:    v.Status,
				ComputeCreatedAt: v.CreatedAt,
			}
		}
	}

	for host, status := range splunkResults {
		if _, ok := hosts[host]; ok {
			hosts[host].SplunkLastSeen = status
		} else {
			hosts[host] = &HostStatus{
				SplunkLastSeen: status,
			}
		}
	}

	saveCsv(formCsv(hosts), config.GetCsvLocation())
	saveCsvDryRun(formCsv(hosts), config.GetCsvLocation())

	ichecker.Check()
}
