package conductor

import (
	"io/ioutil"
	"log"
	"net/http"
	"strings"

	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/config"
	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/misc"
)

func getPage(address string) (result string) {
	resp, err := http.Get(address)
	misc.ErrorCheck(err)
	defer func() { misc.ErrorCheck(resp.Body.Close()) }()
	misc.QuerySentLog(address, resp.StatusCode)
	body, err := ioutil.ReadAll(resp.Body)
	misc.ErrorCheck(err)
	result = string(body)
	return
}

func FetchInstancesDryRun() (instances []string) {
	return instances
}

func getConductorSources() (sources [4]string) {
	sources = config.GetConductorSources()
	return sources
}

func FetchInstances() (instances []string) {
	log.Println("conductor start")
	sources := getConductorSources()
	folderContent := ""

	for _, address := range sources {
		folderContent = getPage(address)
		parsedFolderContent := strings.Split(folderContent, "\n")
		for _, instance := range parsedFolderContent {
			if instance != "" {
				instances = append(instances, misc.UnifyMdbLink(instance, address))
			}
		}
	}
	log.Printf("conductor done\n\n")
	return
}
