package config

type ComputeHostStatus struct {
	Hostname, Status, CreatedAt string
}

type SplunkConfig struct {
	Hostname, JobsPath string
}

type Endpoint struct {
	Hostname, Path string
}

type ComputeEnviroment struct {
	FolderID, URL, Env, PageSize string
}

type ComputeConfig struct {
	IamHost                 Endpoint
	ComputeHost             Endpoint
	PageSize, ReplaceString string
	OauthToken              string
	Enviroments             [4]ComputeEnviroment
}

func GetCsvLocation() (location string) {
	location = "/tmp/test.csv"
	return
}

func GetComputeConfig() (config ComputeConfig) {
	PageSize := "500"
	MDBclustersProdEnv := ComputeEnviroment{
		FolderID: "b1gdepbkva865gm1nbkq",
		URL:      "cloud",
		Env:      "prod",
		PageSize: PageSize,
	}
	MDBclustersPreprodEnv := ComputeEnviroment{
		FolderID: "aoed5i52uquf5jio0oec",
		URL:      "cloud-preprod",
		Env:      "preprod",
		PageSize: PageSize,
	}
	MDBcontrolplaneProdEnv := ComputeEnviroment{
		FolderID: "b1g0r9fh49hee3rsc0aa",
		URL:      "cloud",
		Env:      "prod",
		PageSize: PageSize,
	}
	MDBcontrolplaneEnv := ComputeEnviroment{
		FolderID: "aoeme1ci0qvbsjia4ks7",
		URL:      "cloud-preprod",
		Env:      "preprod",
		PageSize: PageSize,
	}

	config = ComputeConfig{
		IamHost: Endpoint{
			Hostname: "https://iam.api.enviroment.yandex.net/",
			Path:     "iam/v1/tokens",
		},
		ComputeHost: Endpoint{
			Hostname: "https://compute.api.enviroment.yandex.net/",
			Path:     "compute/v1/instances",
		},
		PageSize:      PageSize,
		ReplaceString: "enviroment",
		Enviroments:   [4]ComputeEnviroment{MDBclustersProdEnv, MDBclustersPreprodEnv, MDBcontrolplaneProdEnv, MDBcontrolplaneEnv},
	}
	return
}

func GetConductorSources() (ConductorSources [4]string) {
	ConductorSources = [4]string{
		"https://c.yandex-team.ru/api/groups2hosts/mdb_dataplane_compute_prod",
		"https://c.yandex-team.ru/api/groups2hosts/mdb_dataplane_compute_preprod",
		"https://c.yandex-team.ru/api/groups2hosts/mdb_controlplane_compute_prod",
		"https://c.yandex-team.ru/api/groups2hosts/mdb_controlplane_compute_preprod",
	}
	return
}

func GetSplunkConfig() (SplunkConf SplunkConfig) {
	SplunkConf = SplunkConfig{
		Hostname: "https://search.splunk.yandex.net:8089",
		JobsPath: "/services/search/jobs/export/",
	}
	return
}
