package ichecker

import (
	"bufio"
	"encoding/csv"
	"fmt"
	"io"
	"os"
	"strings"
	"time"

	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/config"
	"a.yandex-team.ru/security/osquery/osquery-consistency/internal/misc"
	// "a.yandex-team.ru/security/osquery/osquery-consistency/internal/vault"
)

type HostStatus struct {
	Hostname         string
	Conductor        string
	ComputeStatus    string
	ComputeCreatedAt time.Time
	SplunkLastSeen   string
}

func Check() {
	CheckCsv(config.GetCsvLocation())
}

func CheckCsv(csvLocation string) {
	csvFile, err := os.Open(csvLocation)
	defer func() { misc.ErrorCheck(csvFile.Close()) }()
	misc.ErrorCheck(err)
	csvReader := csv.NewReader(bufio.NewReader(csvFile))
	var entry HostStatus

	_, err = csvReader.Read() // skip header
	misc.ErrorCheck(err)
	currentTime := time.Now()

	for {
		line, err := csvReader.Read()
		if err == io.EOF {
			break
		} else if err != nil {
			misc.ErrorCheck(err)
		}

		eventTime, _ := time.Parse(time.RFC3339, line[3])
		// misc.ErrorCheck(err)
		entry = HostStatus{Hostname: line[0], Conductor: line[1], ComputeStatus: line[2], ComputeCreatedAt: eventTime, SplunkLastSeen: line[4]}
		// ================================NOALERT================================
		if (strings.ToLower(entry.Conductor) == "true") && (strings.ToUpper(entry.ComputeStatus) == "RUNNING") && (strings.Contains(entry.SplunkLastSeen, ":")) {
		} else if strings.HasPrefix(strings.ToLower(entry.Hostname), "slb-adapter-") {
		} else if strings.Contains(strings.ToLower(entry.Hostname), "dataproc") {
		} else if strings.Contains(strings.ToLower(entry.Hostname), "svc.cloud-preprod.yandex.net") {
		} else if strings.Contains(strings.ToLower(entry.Hostname), "svc.cloud.yandex.net") {
		} else if strings.Contains(strings.ToLower(entry.Hostname), "on.cloud-preprod.yandex.net") {
		} else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) != "") && (entry.SplunkLastSeen == "") {
		} else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "STOPPED") && (strings.Contains(entry.SplunkLastSeen, ":")) {
		} else if (strings.ToLower(entry.Conductor) == "true") && (currentTime.Sub(eventTime).Hours() < 1) {
			// } else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "DELETING") && (entry.SplunkLastSeen == "") {
			// } else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "STOPPING") && (entry.SplunkLastSeen == "") {
			// } else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "PROVISIONING") && (entry.SplunkLastSeen == "") {
			// } else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "STARTING") && (entry.SplunkLastSeen == "") {
			// } else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "RUNNING") && (entry.SplunkLastSeen == "") {
			// =================================ALERT=================================
		} else if (strings.ToLower(entry.Conductor) == "true") && (strings.ToUpper(entry.ComputeStatus) == "RUNNING") && (currentTime.Sub(eventTime).Hours() > 1) {
			fmt.Println("1. ", entry.Hostname, entry.Conductor, entry.ComputeStatus, entry.ComputeCreatedAt, entry.SplunkLastSeen)
		} else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "RUNNING") && (currentTime.Sub(eventTime).Hours() > 1) {
			fmt.Println("2. ", entry.Hostname, entry.Conductor, entry.ComputeStatus, entry.ComputeCreatedAt, entry.SplunkLastSeen)
			// } else if (strings.ToLower(entry.Conductor) == "true") && (strings.ToUpper(entry.ComputeStatus) == "RUNNING") && (entry.SplunkLastSeen == "") {
			// fmt.Println(entry.Hostname, entry.Conductor, entry.ComputeStatus, entry.ComputeCreatedAt, entry.SplunkLastSeen)
			// } else if (strings.ToLower(entry.Conductor) == "true") && (strings.ToUpper(entry.ComputeStatus) == "") && (entry.SplunkLastSeen == "") {
			// fmt.Println(entry.Hostname, entry.Conductor, entry.ComputeStatus, entry.ComputeCreatedAt, entry.SplunkLastSeen)
			// } else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "RUNNING") && (strings.Contains(entry.SplunkLastSeen, ":")) {
			// fmt.Println(entry.Hostname, entry.Conductor, entry.ComputeStatus, entry.ComputeCreatedAt, entry.SplunkLastSeen)
			// 	// ================================NOALERT================================
			// } else if (strings.ToLower(entry.Conductor) == "true") && (strings.ToUpper(entry.ComputeStatus) == "") && (strings.Contains(entry.SplunkLastSeen, ":")) {
			// 	// no entry in ComputeStatus, probably folder is not added
		} else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "") && (strings.Contains(entry.SplunkLastSeen, ":")) {
			// deleted VM during search period
		} else if (strings.ToLower(entry.Conductor) == "") && (strings.ToUpper(entry.ComputeStatus) == "") && (strings.Contains(entry.SplunkLastSeen, "latest")) {
		} else if (strings.ToLower(entry.Conductor) == "conductor") && (strings.ToUpper(entry.ComputeStatus) == "COMPUTE") && (strings.Contains(entry.SplunkLastSeen, "SplunkLastSeen")) {
		} else {
			fmt.Println(entry.Hostname, entry.Conductor, entry.ComputeStatus, entry.ComputeCreatedAt, entry.SplunkLastSeen)
		}
	}
}
