package misc

import (
	"crypto/tls"
	"log"
	"net/http"
	"strings"
)

func ErrorCheck(err error) {
	if err != nil {
		log.Fatal(err)
	}
}

func QuerySentLog(host string, statusCode int) {
	log.Printf("recieved %d from %s", statusCode, host)
}

func UnifyMdbLink(link string, env string) (returnLink string) {
	if strings.Contains(env, "preprod") && strings.HasSuffix(link, "db.yandex.net") {
		returnLink = strings.Replace(link, "db.yandex.net", "mdb.cloud-preprod.yandex.net", -1)
	} else {
		returnLink = strings.Replace(link, "db.yandex.net", "mdb.yandexcloud.net", -1)
	}
	return
}

func CreateHTTPClient() (client *http.Client) {
	tr := &http.Transport{
		TLSClientConfig: &tls.Config{InsecureSkipVerify: true},
	}
	client = &http.Client{Transport: tr}
	return client
}
