package conductor

import (
	"strings"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/security/osquery/osquery-coverage/internal/configproto"
	"a.yandex-team.ru/security/osquery/osquery-coverage/internal/misc"
)

func getPage(conductorURL string) (result string) {
	resp, err := misc.Client.R().
		Get(conductorURL)
	if err != nil {
		misc.Logger.Error("COMPUTE FAILED",
			log.Error(err),
		)
	}

	misc.Logger.Info("Request is done",
		log.String("URL", conductorURL),
		log.String("Status", resp.Status()))
	result = resp.String()

	if resp.StatusCode() < 200 || resp.StatusCode() > 299 {
		misc.Logger.Error(resp.String())
	}
	return
}

func FetchInstancesDryRun(service *configproto.Service) (instances []string) {
	return instances
}

func FetchInstances(service *configproto.Service) (instances []string) {
	misc.Logger.Info("conductor started")
	conductorURL := "https://c.yandex-team.ru/api/groups2hosts/"

	for _, conductorURI := range service.GetConductor() {
		misc.Logger.Info(conductorURI)
		folderContent := getPage(conductorURL + conductorURI)
		parsedFolderContent := strings.Split(folderContent, "\n")
		for _, instance := range parsedFolderContent {
			if instance != "" {
				instances = append(instances, misc.UnifyMdbLink(instance, conductorURI))
			}
		}
	}

	misc.Logger.Info("conductor done")
	return
}
