package config

import (
	"github.com/golang/protobuf/proto"

	"a.yandex-team.ru/security/osquery/osquery-coverage/internal/configproto"
)

func getComputeOauthToken() (oauth string) {
	oauth = ""
	return
}

func getSplunkCredentials() (login string, password string) {
	login = "robot-huli-jing"
	password = ""
	return
}

func GetServices() [2]*configproto.Service {
	pagesize := "500"
	iamhostname := "https://iam.api.enviroment.yandex.net/"
	iampath := "iam/v1/tokens"
	computehostname := "https://compute.api.enviroment.yandex.net/"
	computepath := "compute/v1/instances"
	replacestring := "enviroment"
	computeoauthtoken := getComputeOauthToken()
	splunkUsername, splunkPassword := getSplunkCredentials()

	Services := [...]*configproto.Service{
		{
			Service: *proto.String("compute"),
			Splunkenviroment: &configproto.SplunkEnviroment{
				Query:    "ycloud-hv-config",
				Username: splunkUsername,
				Password: splunkPassword,
			},
			Conductor: []string{"cloud_prod_compute"},
			Compute: &configproto.ComputeConfig{
				Iamhost: &configproto.Endpoint{
					Hostname: iamhostname,
					Path:     iampath,
				},
				Computehost: &configproto.Endpoint{
					Hostname: computehostname,
					Path:     computepath,
				},
				Pagesize:      pagesize,
				Replacestring: replacestring,
				Oauthtoken:    computeoauthtoken,
				Computeenviroment: []*configproto.ComputeEnviroment{
					{
						Folderid: "baremetal",
						Url:      "cloud",
						Env:      "prod",
						Pagesize: pagesize,
					},
				},
			},
			Inventory: *proto.String("true"),
		},
		{
			Service: *proto.String("mdb"),
			Splunkenviroment: &configproto.SplunkEnviroment{
				Query:    "ycloud-mdb-*",
				Username: splunkUsername,
				Password: splunkPassword,
			},
			Conductor: []string{
				"mdb_dataplane_compute_prod",
				"mdb_dataplane_compute_preprod",
				"mdb_controlplane_compute_prod",
				"mdb_controlplane_compute_preprod",
			},
			Compute: &configproto.ComputeConfig{
				Iamhost: &configproto.Endpoint{
					Hostname: iamhostname,
					Path:     iampath,
				},
				Computehost: &configproto.Endpoint{
					Hostname: computehostname,
					Path:     computepath,
				},
				Pagesize:      pagesize,
				Replacestring: replacestring,
				Oauthtoken:    computeoauthtoken,
				Computeenviroment: []*configproto.ComputeEnviroment{
					{
						Folderid: "b1gdepbkva865gm1nbkq",
						Url:      "cloud",
						Env:      "prod",
						Pagesize: pagesize,
					},
					{
						Folderid: "aoed5i52uquf5jio0oec",
						Url:      "cloud-preprod",
						Env:      "preprod",
						Pagesize: pagesize,
					},
					{
						Folderid: "b1g0r9fh49hee3rsc0aa",
						Url:      "cloud",
						Env:      "prod",
						Pagesize: pagesize,
					},
					{
						Folderid: "aoeme1ci0qvbsjia4ks7",
						Url:      "cloud-preprod",
						Env:      "preprod",
						Pagesize: pagesize,
					},
				},
			},
			Inventory: *proto.String("false"),
		},
	}
	return Services
}

type HostStatus struct {
	Conductor        string
	ComputeStatus    string
	ComputeCreatedAt string
	SplunkLastSeen   string
}
