package misc

import (
	"net/http"
	"strings"
	"time"

	"github.com/go-resty/resty/v2"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/zap"
)

var Client = resty.New().
	SetRetryCount(5).
	SetTimeout(360 * time.Second).
	SetTransport(&http.Transport{
		MaxConnsPerHost:       100,
		MaxIdleConnsPerHost:   10,
		TLSHandshakeTimeout:   30 * time.Second,
		ResponseHeaderTimeout: 30 * time.Second,
		ExpectContinueTimeout: 30 * time.Second,
	}).
	//SetTLSClientConfig(&tls.Config{ InsecureSkipVerify: true }). // for splunk
	SetHeaders(map[string]string{
		"Content-Type": "application/json",
		"User-Agent":   "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36",
	})

func UnifyMdbLink(link string, env string) (returnLink string) {
	if strings.Contains(env, "preprod") && strings.HasSuffix(link, "db.yandex.net") {
		returnLink = strings.Replace(link, "db.yandex.net", "mdb.cloud-preprod.yandex.net", -1)
	} else {
		returnLink = strings.Replace(link, "db.yandex.net", "mdb.yandexcloud.net", -1)
	}
	return
}

var Logger, LoggerErr = zap.New(zap.ConsoleConfig(log.InfoLevel))
