package cache

import (
	"errors"
	"time"

	"a.yandex-team.ru/security/osquery/osquery-metrics/internal/resulter"
)

const TTL = 60

type Entry struct {
	data   *resulter.WebResponse
	expire time.Time
}

type MapCache struct {
	Storage map[string]*Entry
}

type MCache interface {
	Get(key string) (*resulter.WebResponse, error)
	Set(key string, response *resulter.WebResponse) error
	NewItem(*resulter.WebResponse) *Entry
}

func (c MapCache) Get(k string) (*resulter.WebResponse, error) {
	if _, found := c.Storage[k]; found {
		if time.Time.Before(c.Storage[k].expire, time.Time{}) {
			return c.Storage[k].data, nil
		}
	}
	return nil, errors.New("cache miss")
}

func (c MapCache) Set(k string, r *resulter.WebResponse) error {
	if _, found := c.Storage[k]; found {
		if time.Time.Before(c.Storage[k].expire, time.Time{}) {
			c.Storage[k] = c.NewItem(r)
		} else {
			return nil
		}
	} else {
		c.Storage[k] = c.NewItem(r)
		return nil
	}
	return nil
}

func (c MapCache) NewItem(data *resulter.WebResponse) *Entry {
	t := new(Entry)
	t.data = data
	t.expire = time.Now().Add(TTL)
	return t
}

func NewCache() *MapCache {
	m := make(map[string]*Entry)
	return &MapCache{m}
}
